/* Client */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <fcntl.h>

#include "copy.h"
#include "tcputils.h"

int main(int argc, char* argv[])
{
	int sockfd;
	int fd;
	int size;
	char bResult;

    // Check parameters, I add a new parameter for destination filename.
    if (argc != 4)
    {
        printf("Usage: getfile <ipaddr> <source filename> <destination filename>\n");
        exit(EXIT_SUCCESS);
    }

	// Create a socket for the client.
	sockfd=open_clientsock(argv[1],9735);

	int res;
	// Send source filename to server
	res = write(sockfd, argv[2], strlen(argv[2])+1);

    // Get server response
    res = read(sockfd, &bResult, 1);

    if (bResult == '1')     // Server is ready to send file
    {
        size = 0;

        // Create destination file
        fd = open(argv[3],O_WRONLY|O_CREAT,0666);

        if (fd < 0)     // create file error
        {
            perror("client:");
        }

        // Copy file
        size=copy_file(sockfd,fd);

        printf("GET Success (%d bytes)\n", size);
        close(fd);
    }
    else
    {
        printf("Error!\n");
    }

	close(sockfd);
	exit(EXIT_SUCCESS);
}
